*-------------------------------------------------------------------------------
/* title : Create a dataset with lagged values for the rest of proxies
   source: WIOD Release 2016	 
   input : $temp/Sample.dta; 
		   $temp/Proxies.dta
		   $temp/Proxies_IV1.dta
		   $temp/Proxies_IV2.dta
		   $temp/Proxies_IV1noUS.dta
		   $temp/Proxies_IV2noUS.dta
		   $temp/Proxies_development_split.dta
   output: $temp/Sample_lag_proxies */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*===============================================================================
* Create lag values for the variables used in other than the Baseline model
*===============================================================================
use bvdid newid year country countryWIOD CPA sub_for shh_for sub_dom shh_dom down0dIM up0dEX up0dIM down0dEX IM EX using "$temp/Sample.dta", clear

* Domestic links
replace sub_for = 0 if sub_dom==1 | shh_dom==1
replace shh_for = 0 if sub_dom==1 | shh_dom==1
gen D = 1
replace D = 0 if sub_for==1 | shh_for==1 		// Foreign owned firms with no Domestic ownership
drop sub_for shh_for sub_dom shh_dom
qui foreach var in down0dIM up0dEX up0dIM down0dEX IM EX {
	cap gen `var'_D = `var'*D
	drop `var'
}

* Other variants of proxies
gen country_backup = country
gen industry = CPA
replace country = countryWIOD

merge m:1 country industry year using "$temp/Proxies.dta", nogen keep(matched) keepusing(down0dIMbroad up0dEXbroad downIM upIM downEX upEX down0dIM_00 up0dIM_00 down0dEX_00 up0dEX_00)

* Development Split of Proxies 
merge m:1 country industry year using "$temp/Proxies_development_split.dta", nogen keep(matched) keepusing(down0dIM_dvlpd up0dEX_dvlpd up0dIM_dvlpd down0dEX_dvlpd down0dIM_dvlpng up0dEX_dvlpng up0dIM_dvlpng down0dEX_dvlpng IM_dvlpd EX_dvlpd IM_dvlpng EX_dvlpng)

* IVs
merge m:1 country industry year using "$temp/Proxies_IV1.dta", nogen keep(matched) keepusing(down0dIM_iv1 up0dEX_iv1 up0dIM_iv1 down0dEX_iv1 IM_iv1 EX_iv1)
merge m:1 country industry year using "$temp/Proxies_IV2.dta", nogen keep(matched) keepusing(down0dIM_iv2 up0dEX_iv2 up0dIM_iv2 down0dEX_iv2 IM_iv2 EX_iv2 IM_iv2_0d EX_iv2_0d)

* IVs Without US
merge m:1 country industry year using "$temp/Proxies_IV1noUS.dta", nogen keep(matched) keepusing(down0dIM_iv1noUS up0dEX_iv1noUS up0dIM_iv1noUS down0dEX_iv1noUS IM_iv1noUS EX_iv1noUS)
merge m:1 country industry year using "$temp/Proxies_IV2noUS.dta", nogen keep(matched) keepusing(down0dIM_iv2noUS up0dEX_iv2noUS up0dIM_iv2noUS down0dEX_iv2noUS IM_iv2noUS EX_iv2noUS IM_iv2_0dnoUS EX_iv2_0dnoUS)

replace country = country_backup
drop country_backup industry countryWIOD

*-----------------------------------Lag values----------------------------------
xtset newid year

qui foreach var of varlist D down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM_D EX_D 																///
						down0dIMbroad    up0dEXbroad downIM upIM downEX upEX down0dIM_00 up0dIM_00 down0dEX_00 up0dEX_00 					///
						down0dIM_dvlpd   up0dEX_dvlpd 	up0dIM_dvlpd 	down0dEX_dvlpd 	 IM_dvlpd 	EX_dvlpd 								///
						down0dIM_dvlpng  up0dEX_dvlpng 	up0dIM_dvlpng 	down0dEX_dvlpng  IM_dvlpng 	EX_dvlpng 								///
					    down0dIM_iv1 	 up0dEX_iv1 	up0dIM_iv1 		down0dEX_iv1 	 IM_iv1 	EX_iv1 									///
						down0dIM_iv2 	 up0dEX_iv2 	up0dIM_iv2 		down0dEX_iv2 	 IM_iv2 	EX_iv2 	   IM_iv2_0d 	 EX_iv2_0d 		///
						down0dIM_iv1noUS up0dEX_iv1noUS up0dIM_iv1noUS	down0dEX_iv1noUS IM_iv1noUS EX_iv1noUS 								///
						down0dIM_iv2noUS up0dEX_iv2noUS up0dIM_iv2noUS	down0dEX_iv2noUS IM_iv2noUS EX_iv2noUS IM_iv2_0dnoUS EX_iv2_0dnoUS {
	* Lags
	forvalues i = 1/2 {
		gen L`i'_`var' = L`i'.`var'
	}
	
	* First-differences
	gen D_`var' = D.`var'
	forvalues i = 1/12 {
 		gen DL`i'_`var' = L`i'.D_`var'
	}
	drop D_`var'
}

qui compress
saveold "$temp/Sample_lag_proxies", replace v(13)
